/******************************************************************
 * Template for creating PowerBar modules
 * written by Steve Sprang
 * Copyright  1997
 *
 * Note: The functions below are sufficient for simple modules.
 * They are intended to allow user interaction without adding more
 * views to the parent view. It is possible to ignore all the
 * functions except module_get_width(), module_create(), and
 * module_quit(), performing all user interaction by adding custom
 * views to the owning view.
 * 
 ******************************************************************/ 
 
#include <module.h>

/*

	FROM THE AUTHOR:
	
		I took Steve's nodule template file, and in ten minutes, minus
		the 15 I spent getting that icon 'just so', we have this module.
		I wouldn't call it geat coding style but for less than 50 lines
		that I added, its fine.
		
		Additional functionality coming:
		
			Change the number of defined workspaces.
			Launching the Workspace applicaiton.
			
		Now that I have this, I don't use SpaceSwitcherII anymore.....
		
		-Sean Allen
		Infant Software
		4:30 AM February 29, 1997				

*/

// #include <BeHeaders>
// I added the above line to module.h -STA

#define ChangeSpace		'SPCE'

void menu_madness();

BPopUpMenu * menu;
long numSpaces;

#define BT8B			B_TRANSPARENT_8_BIT

unsigned char workspace[] = 
{ 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x00, BT8B, BT8B, 
0x00, 0x00, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x89, 0x89, 
0x00, 0x00, 0x3A, 0x39, 0x00, 0x00, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x89, 
0x89, 0x89, 0x89, 0x89, 0x06, 0x05, 0x39, 0x00, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 
0x89, 0x15, 0x15, 0x15, 0x89, 0x89, 0x00, 0x00, 0x00, 0x00, 0x00, 
BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, 
0x00, 0x89, 0x15, 0x15, 0x0E, 0x00, 0x00, 0xAA, 0x0E, 0x07, 0x00, 
0xD0, 0x00, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, 
BT8B, 0x00, 0xAA, 0xAA, 0x89, 0x89, 0x15, 0xAA, 0x89, 0x89, 0x00, 
0x00, 0xD7, 0xD7, 0x00, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, 
BT8B, BT8B, BT8B, 0x00, 0xD7, 0xD7, 0xAA, 0xAA, 0x89, 0x89, 0x89, 
0x89, 0x89, 0xD0, 0xD7, 0xD7, 0x00, BT8B, BT8B, BT8B, BT8B, BT8B, 
0xFF, BT8B, BT8B, BT8B, BT8B, 0x00, 0xAA, 0xD7, 0xD7, 0xD7, 0xAA, 
0xAA, 0x89, 0x89, 0xD0, 0xD7, 0xD7, 0xD0, 0x00, BT8B, BT8B, BT8B, 
BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, 0x00, 0xAA, 0xAA, 0xD7, 
0xD7, 0xD7, 0xD7, 0xAA, 0xD0, 0xD7, 0xD7, 0xD0, 0xD0, 0x00, BT8B, 
BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, 0x00, 0xD0, 
0xD0, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD7, 0xD0, 0xD0, 0xD0, 
0x00, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, 
0x00, 0xAA, 0xAA, 0xD7, 0xD7, 0xD7, 0x00, 0xAA, 0xAA, 0xD0, 0xD0, 
0xD0, 0xD0, 0x00, 0x0A, 0x0A, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, 
BT8B, BT8B, 0x00, 0xAA, 0xAA, 0xD7, 0xD7, 0x00, 0x00, 0xAA, 0xAA, 
0xD0, 0xD0, 0xD0, 0xD0, 0x00, 0x0A, BT8B, BT8B, BT8B, BT8B, 0xFF, 
BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x00, 0xD7, 0x00, 0x09, 0x00, 
0xD0, 0xD0, 0xD0, 0xD0, 0xD0, 0x00, 0x0A, BT8B, BT8B, BT8B, BT8B, 
BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x09, 
0x0A, 0x00, 0xAA, 0xAA, 0xD0, 0xD0, 0x00, 0x09, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, 0x00, 0xAA, 0xAA, 0xD0, 0x00, 0x0A, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0x00, 0x00, 0x00, 0x09, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 0xFF, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, 0xFF, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, BT8B, 
BT8B, BT8B, BT8B, BT8B, 0xFF
};


/*
these variable are not required, but global variables
are needed to maintain the state of the module. The following
are useful to keep around.
*/

BView		*owner;
BRect		bounds;
BBitmap		*bmap;
BView		*v;


/*
This function is called when the app first opens the module.
It should return the amount of space the module would like to get
*/
long module_get_width()
{
	// make a square
	return kHEIGHT;
}

/*
This is called when the app actually creates a view for the module.
The view is passed as a parameter.
*/
void module_create(BView *mod)
{
	// store the owning view and its bounds
	owner = mod;
	bounds = owner->Bounds();
	
	BRect myBounds(0.0, 0.0, 23.0, 23.0);
				
	// create a bmap for drawing
	bmap = new BBitmap(myBounds, B_COLOR_8_BIT, TRUE);
	bmap->SetBits(workspace, (23 * 23 * 8), 0, B_COLOR_8_BIT);
	
	numSpaces = 0;
	menu = new BPopUpMenu("PowerBar: Workspaces", true, false); //, B_ITEMS_IN_ROW);
}

/*
This is called every time a pulse is registered in the owning
view. The PowerBar window is currently set to pulse every 1/3
second or so.
*/
void module_pulse()
{
	// nothing
}

/*
Called when the owning view is destroyed. Clean up allocated
variables here
*/
void module_quit()
{
	BMenuItem * item;
	while ((item = menu->RemoveItem(long(0))) != NULL)
		delete item;
	delete menu;
	delete bmap;
}

/*
Called when the owning view wants the module to redraw.
*/
void module_draw()
{
	BWindow * window = owner->Window();
	
	window->Lock();
	
	/* cool 3d background stuff */
	owner->SetHighColor(kBGCOLOR);
	owner->SetLowColor(kBGCOLOR);
	owner->FillRect(bounds);
	
	BPoint tl, tr, bl, br;
	tl = BPoint(bounds.left, bounds.top);
	tr = BPoint(bounds.right, bounds.top);
	bl = BPoint(bounds.left, bounds.bottom);
	br = BPoint(bounds.right, bounds.bottom);
	
	owner->SetHighColor(kSHADOW);
	owner->StrokeLine(br, tr);
	owner->StrokeLine(br, bl);
		
	owner->SetHighColor(kHILITE);
	owner->StrokeLine(tl, tr);
	owner->StrokeLine(tl, bl);
	/***/
	
	owner->MovePenTo(3.5, 3.5);
	owner->SetDrawingMode(B_OP_OVER);	
	owner->DrawBitmapAsync(bmap);

	owner->Sync();

	window->Unlock();
}

/*
Called when the owning view received a BMessage.
*/
void module_message_received(BMessage *msg)
{
	if (msg->what == ChangeSpace) {
		long newSpace = msg->FindLong("space");
		if (newSpace != current_workspace())
			activate_workspace(newSpace);
	}
}

/*
Called when the owning view receives a mouse click
*/
void module_mouse_down(BPoint point, long)
{
	menu_madness();
	menu->Go(owner->ConvertToScreen(point),TRUE);
}

/*
Called when the owning view receives a MouseMoved message.
*/
void module_mouse_moved(BPoint point, ulong transit, BMessage *msg)
{
	// nothing
}

void menu_madness()
{
	long ws_count = count_workspaces();
	if (ws_count > numSpaces) {
		BMessage * message;
		BMenuItem * item;
		while (ws_count > numSpaces) {
			message = new BMessage(ChangeSpace);
			message->AddLong("space", numSpaces);
			char title [ 3 ];
			sprintf(title, "%d", numSpaces + 1);
			item = new BMenuItem(title, message);
			item->SetTarget((BHandler *)owner);
			menu->AddItem(item);
			numSpaces++;
		}			
	} else if (ws_count < numSpaces) {
		BMenuItem * ptrItem;
		while (ws_count < numSpaces) {
			ws_count--;
			ptrItem = menu->RemoveItem(ws_count);
			if (ptrItem)
				delete ptrItem;
		}	
	}
	menu->ItemAt(current_workspace())->SetMarked(true);
}