/**************************************************************
 * module.h
 * written by Steve Sprang
 * Copyright  1997
 *
 *************************************************************/
 
#pragma once
#pragma export on

// modules need not support all functions below...
// at a minimum module_get_width() MUST be provided and 
// probably module_create() if anything useful is to be done
extern "C" {
	long module_get_width();
	void module_create(BView *);
	void module_quit();
	void module_draw();
	void module_mouse_down(BPoint, long);
	void module_mouse_moved(BPoint, ulong, BMessage *);
	void module_message_received(BMessage *);
	void module_pulse();
}

#pragma export reset

// this is the height of the window and is unchanging
#define kHEIGHT	30

/***********************************************************
 * this message can be posted to an owning view as follows:
 * 
 *		BMessage *msg = new BMessage(mRESIZE);
 *		msg->AddLong("width", new_width);
 *		owner_view->Window()->PostMessage(msg, owner_view);
 *
 * NOTE: new_width is an actual size, NOT a delta
 *
 * The owning view knows how to resize itself and the window
 * appropriately
 **********************************************************/
enum {
	mRESIZE = 'rsiz'
};

// color constants for consistent modules
const rgb_color kBGCOLOR = {200,200,200};
const rgb_color kHILITE = {255,255,255};
const rgb_color kSHADOW = {150,150,150};