//          File: nameSID_r1.zip
//        Author: Rainer Riedl (rainer.riedl@stud.fh-regensburg.de)
//       Release: 1 (Feb. 12th, 1997)
// Compatibility: DR8.2
//      Location: contrib/contrib/add-ons/browser
//   Description: Browser add-on: sets SID tune name as filename
//         Notes: Ever got a SID tune with those silly 8.3-DOS-filenames? 
//                Heres the solution. 
//--------------------------------------------------------------------------------------------

#include	<ctype.h>
#include	<string.h>

#pragma export on
void process_refs(record_ref aReference, BMessage* msg, void*);
#pragma export reset


struct PSIDHeader
{
	unsigned long	id;				// 'PSID'
	unsigned short	version;		// Version 1 or 2
	unsigned short	length;			// Length of header
	unsigned short	start;			// C64 load address
	unsigned short	init;			// C64 address of init routine
	unsigned short	main;			// C64 address of replay routine
	unsigned short	number;			// Number of subsongs
	unsigned short	defsong;		// Main subsong number (1..255)
	unsigned short	speedhi;		// Speed flags (1 bit/song)
	unsigned short	speedlo;
	unsigned char	name[32];		// Module name
	unsigned char	author[32];		// Author
	unsigned char	copyright[32];	// Copyright info
	unsigned short	flags;			// Flags (only in version 2 header)
	unsigned long	reserved;
};


//--------------------------------------------------------------------------------------------
void main()
{
}


//--------------------------------------------------------------------------------------------
void Error(const char* const Text, const char* const Insert)
{
	const char* const title = "nameSID-Error:\n\n";

	char* format = new char[strlen(title)+strlen(Text)+1];
	strcpy(format, title);
	strcat(format, Text);
	
	char* atext = new char[strlen(format)+strlen(Insert)+1];
	sprintf(atext, format, Insert);

	BAlert* alert = new BAlert("nameSID", atext, "Cancel", NULL, NULL, B_WIDTH_AS_USUAL, B_STOP_ALERT);

	alert->Go();


	delete [] atext;
	delete [] format;
}


//--------------------------------------------------------------------------------------------
void ProcessFile(BFile *File)
{
	char name[B_FILE_NAME_LENGTH+1];
	memset(name, 0, B_FILE_NAME_LENGTH);

	File->Open(B_EXCLUSIVE);
	if (File->Error() == B_NO_ERROR)
	{
		PSIDHeader header;
		File->Read(&header, sizeof(PSIDHeader));
		if (header.id == 'PSID')
		{
			File->SetTypeAndApp('PSID', 'SidP');
			strncpy(name, (char*)header.name, 32);

			// replace time "TIME: x:xx" to [time x.xx]
			char* time = &name[strlen(name)-10];
			if ((strncmp(time, "TIME: ", 6) == 0) && (time[7] == ':'))
			{
				memcpy(time, "[time", 5);
				time[7] = '.';
				time[10] = ']';
			}

			// replace time "T: x:xx" to [time x.xx]
			time = &name[strlen(name)-7];
			if ((strncmp(time, "T: ", 3) == 0) && (time[4] == ':'))
			{
				time[9] = time[6];
				time[8] = time[5];
				time[6] = time[3];
				memcpy(time, "[time ", 6);
				time[7] = '.';
				time[10] = ']';
			}

			// only allowed chararcters
			for (int i=0; i< strlen(name); i++)
			{
				if (isprint(name[i]) == 0)
					name[i] = '';
				else
					switch (name[i])
					{
						case '\\':	name[i] = '|';	break;
						case '/':	name[i] = '|';	break;
						case ':':	name[i] = '=';	break;
						case '*':	name[i] = '';	break;
						case '?':	name[i] = '';	break;
					}
			}
		}
		else
		{
			File->GetName(name);
			Error("Sorry, '%s'\nis not a SID!", name);
		}
	}
	File->Close();
	if (name[0] != '\0')
	{
		switch (File->SetName(name))
		{
			case B_NAME_IN_USE:	Error("The name '%s' is \nalready in use!", name);	break;
			case B_ERROR:		Error("Cant set the name '%s'!", name);			break;
		}
	}
}


//--------------------------------------------------------------------------------------------
void process_refs(record_ref, BMessage* Msg, void*)
{
	ulong		type;
	long		ref_cnt;
	BFile		file;
	BDirectory	dir;
	record_ref	ref;

	Msg->GetInfo("refs", &type, &ref_cnt);
	if (ref_cnt == 0)
		Error("No valid selection found!", "");
	else
	{
		for (long i=0; i<ref_cnt; i++)
		{
			ref = Msg->FindRef("refs", i);
			if (does_ref_conform(ref, "File"))
			{
				file.SetRef(ref);
				if (file.Error() == B_NO_ERROR)  ProcessFile(&file);
			}
		}
	}
}

