//	Code for a simple BeIDE Editor add-on.  
//	Add the method name at the insertion point.
//	It is guessed from the filename.
//
//	If file is .h only class name is added
//	If file is .c** class name and :: are added...
//
//	version 1.0
//	written by Hubert Figuiere
//	July 4th 1996
//
//  13Aug96
//	-added support for .h
//  11oct96
//	-added support for CW DR2 (finally)
//
//	version 1.1 (first public release)
//
//	4nov96
//	-added support for CW DR2.1
//  25Feb96
//  -first public release


#include <string.h>

#include <TextView.h>
#include <Window.h>

#include "MTextAddOn.h"

#pragma export on
extern "C" {
        long perform_edit(MTextAddOn *view);
}
#pragma export reset


/* Public interface for the add-on */
long perform_edit(MTextAddOn *view)
{
	const char * winName = view->Window()->Title();		//title of parent window
	int nameLength = strlen(winName);			//length of windows name
	char * className = NULL;
	
	
	// filename is *.cpp
	if (winName [nameLength - 4] == '.') {
		className = new char [nameLength - 1];	
		memcpy(className, winName, nameLength - 4);
																				//copy and remove the suffix
		className [nameLength - 4] = ':';
		className [nameLength - 3] = ':';		//add ::
		
		className [nameLength - 2] = 0;			//terminate the string
		
		view->Insert(className);
		
		delete [] className;
		
		return 0;
	}/*if*/
	
	if (winName [nameLength - 2] == '.') {
		className = new char [nameLength - 1];	
		memcpy(className, winName, nameLength - 2);
		
		className [nameLength - 2] = 0;
		
		view->Insert(className);
		
		delete [] className;
		
		return 0;
	}
	
	return 0;
}

