//==================================================================
//	MTextAddOn.h
//	Copyright 1996  Metrowerks Corporation, All Rights Reserved.
//==================================================================
//	This is a proxy class used by Editor add_ons.  It does not inherit from BView
//	but provides an abstract interface to a text engine.
 
#pragma once

#include <Window.h>

class MIDETextView;


class MTextAddOn
{
public:
								MTextAddOn(
									MIDETextView&	inTextView);
	virtual						~MTextAddOn();
	virtual	const char*			Text();
	virtual	long				TextLength() const;
	virtual	void				GetSelection(
									long *start, 
									long *end) const;
	virtual	void				Select(
									long newStart, 
									long newEnd);
	virtual void				Delete();
	virtual void				Insert(
									const char* inText);
	virtual void				Insert(
									const char* text, 
									long length);

	virtual	BWindow*			Window();
	virtual record_ref			RecordRef();

private:

	MIDETextView&				fText;
};
