/*
  rlogin.cpp - remote2local thread for rlogin client for BeOS
  Copyright (C) 1998 Uwe Ohse

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2, or (at your option)
  any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.
*/                                                                                            

#include "rlogin.h"


static void
sigwinch_handler(int sig)
{
	;
}

int32 
writestdout_c::thread_func(void)
{
    // read from remote, write to stdout 
    int r;
    char rbuf[1024];
    char c;
    signal(SIGWINCH, sigwinch_handler);
FILE *f;

    do {
	r = recv(sock, &c, 1, 0);
    } while (r == -1 && errno == EINTR);
    if (r != 1) {
	myperror("protocol error");
	kill_thread(readstdin->getid());
	exit_thread(errno);
    }
    if (r && c != 0) {
	// error
	myperror("protocol error");
	while (r == 1) {
	    do {
		r = recv(sock, &c, 1, 0);
	    } while (r == -1 && errno == EINTR);
	    if (r)
		write(2, &c, 1);
	}
	kill_thread(readstdin->getid());
	exit_thread(errno);
    }
f=fopen("out","w");
if (!f)
	myperror("out");

    while (1) {
	int count;
	int off;
#if 0
	// MSG_OOB completely broken under BeOS
	do {
		fd_set set1,set2;
		FD_ZERO(&set1);
		FD_SET(sock-OPEN_MAX,&set1);
		FD_ZERO(&set2);
		FD_SET(sock-OPEN_MAX,&set2);
		r=select(sock-OPEN_MAX+1,&set1,NULL,&set2,NULL);
		if (r<-1)  {
			if (errno==EINTR) 
				continue;
			myperror("select");
			kill_thread(readstdin->getid());
			exit_thread(errno);
		}
		printf("r=%d,%d,%d\n",r,
			FD_ISSET(sock-OPEN_MAX,&set1),
			FD_ISSET(sock-OPEN_MAX,&set2));
		if (FD_ISSET(sock-OPEN_MAX,&set2)) {
			unsigned char c;
			r=recv (sock, &c, 1, MSG_OOB);
			if (r<0) {
				;
				// myperror("recv OOB");
			} else if (r>0) {
				printf("got OOB %d %x\n",r,c);
			}
			continue;
		}
	} while(0);
#endif
	r = recv(sock, rbuf, sizeof(rbuf), 0);
	if (r < 0 && errno != EAGAIN && errno != EINTR) {
		myperror("recv");
		kill_thread(readstdin->getid());
	    exit_thread(errno);
	} else if (r < 0)
	    continue;
	if (r == 0) {
	    fprintf(stderr, "rlogin: connection lost\r\n");
		kill_thread(readstdin->getid());
	    exit_thread(errno);
	}
if (f) { fwrite(rbuf,1,r,f);fflush(f); }

#define HACK_OOB
#ifdef HACK_OOB
	char wbuf[sizeof(rbuf)];
	static last_char=0;
	for (off=0,count=0;count<r;count++) {
		unsigned char c;
		c=rbuf[count];
//   02   A control byte of hex 02 causes the client to discard all buffered
//        data received from the server that has not yet been written to the
//        client user's screen.
		if (c==0x02) {
		// sorry, i've already written them. Anything
		// now in the buffer was sent after the 0x02.
			last_char=0x02;
			off=0;
			break;
			continue;
		}
//   10   A control byte of hex 10 commands the client to switch to "raw"
//        mode, where the START and STOP characters are no longer handled by
//        the client, but are instead treated as plain data.
		if (c==0x10) {
			readstdin->change_mode(MODE_RAW);
			last_char=0x10;
			continue;
		}

//   20   A control byte of hex 20 commands the client to resume interception
//        and local processing of START and STOP flow control characters.
// can't emulate that ... 0x20 is space
// but often enough 0x10 0x20 follow each other.
		if (c==0x20 && last_char==0x10) {
			readstdin->change_mode(MODE_COOKED);
			continue;
		}
		last_char=c;

		if (c==0x80) {
			signal(SIGWINCH,SIG_IGN);
			readstdin->Sigwinch();
			send_signal(readstdin->getid(),SIGWINCH);
			continue;
		}
		wbuf[off++]=c;
	}
	count = off;
	off = 0;
	while (count) {
	    r = write(1, rbuf + off, count);
	    if (r < 0) {
			// out terminal is gone? no way to tell this ...
			myperror("terminal gone");
			kill_thread(readstdin->getid());
			exit_thread(errno);
	    }
	    if (r == 0)
		sleep(1);
	    count -= r;
	    off += r;
	}
#else
	count = r;
	off = 0;
	while (count) {
	    r = write(1, rbuf + off, count);
	    if (r < 0) {
		// out terminal is gone? no way to tell this ...
		kill_thread(readstdin->getid());
		exit_thread(errno);
	    }
	    if (r == 0)
		sleep(1);
	    count -= r;
	    off += r;
	}
#endif
    }
    return 0;
}

writestdout_c::writestdout_c(int sock)
{
    this->sock = sock;
    this->id = spawn_thread(static_thread_func, "remote2local", 
	B_LOW_PRIORITY, this);
}

